using log4net;
using Microsoft.Azure.WebJobs;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.ValidationDataService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class ValidationDataTimerTrigger
    {
        [FunctionName("ValidationDataTimerTrigger")]
        public static async Task Run([TimerTrigger("0 0 3 * * 0")]TimerInfo validationDataTimer, 
            [Inject]IValidationDataService validationDataService,
            [Inject] ILog logger)
        {
            // 2 seconds - "0 */2 * * * *"
            // TODO - Every Sunday at 3:00AM - 0 0 3 * * 0
            try
            {
                logger.Info($"Start ValidationDataTimerTrigger function");

                await validationDataService.ProcessData();

                logger.Info($"End ValidationDataTimerTrigger");
                //logger.Info($"ValidationDataTimerTrigger will run again on: {validationDataTimer.Schedule.GetNextOccurrence(DateTime.Now)}");
            }
            catch (Exception ex)
            {
                logger.Error($"There was a problem with ValidationDataTimerTrigger Processing.", ex);
            }
        }
    }
}